/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#define DSP_SPACE

///////////////Internal memory space
#ifdef DSP_SPACE
#define local_cur_y_address (0x20800>>1)
#define local_cur_u_address (local_cur_y_address+0x600) //0xB00(96*16)
#define local_cur_v_address (local_cur_u_address+0x180) //0x180(48*8)

#define local_refn_y_address (0xFE8>>1)
#define local_refn_u_address (local_refn_y_address+0x1800)  //0x1800=6144=48*16*8
#define local_refn_v_address (local_refn_u_address+0x600)   //0x600=1536=24*8*8

#define interpolation_global_src_address (0x220>>1)
#define interpolation_global_dst_address (interpolation_global_src_address+0x480)   //0x480=1152
#define bitsteam_internal_address (0x27310>>1) //(0x24F70>>1)
#define macroblock_buffer_address (0x21A00>>1)
#define clip_table_address (0x20000>>1)

////////////////////External
//#define input_bitbuf_address 0x280000 //0x340000~400000 =>786432 input bitstream should limit to 768 bytes
#define Bistream_address 0x280000   //64kbyts frame size

#define cur_y_address 0x00380000+0x2000 //CIF is 352*288=0x18C00
#define cur_u_address 0x003A0000+0x1000 //CIF is 176*144=0x6300
#define cur_v_address 0x003A8000+0x1000

#define refn_y_address 0x003B0000+0x2000
#define refn_u_address 0x003D0000+0x1000
#define refn_v_address 0x003D8000+0x1000

#define FRAME_BUFFER_address 0x300010
#endif
